<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Widget_Base;

/**
 *
 * Working Process Widget .
 *
 */
class Bizino_Working_Process extends Widget_Base
{

    public function get_name()
    {
        return 'bizinoworkingprocess';
    }

    public function get_title()
    {
        return __('Working Process', 'bizino');
    }

    public function get_icon()
    {
        return 'eicon-code';
    }

    public function get_categories()
    {
        return ['bizino'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'working_process_section',
            [
                'label' => __('Working Process', 'bizino'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'tab_title', [
                'label'         => esc_html__('Tab Title', 'bizino'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => esc_html__("Our Mission", 'bizino'),
                'description'   => esc_html__('enter tab title', 'bizino')
            ]
        );
        $repeater->add_control(
            'tab_thumb_image', [
                'label'         => esc_html__('Tab Thumb Image', 'bizino'),
                'type'          => Controls_Manager::MEDIA,
                'show_label'    => false,
                'description'   => esc_html__('upload tab thumb image', 'bizino'),
                'default'       => [
                    'src'   => Utils::get_placeholder_image_src()
                ],
            ]
        );
        $repeater->add_control(
            'tab_details_subtitle', [
                'label'         => esc_html__('Tab Details Subtitle', 'bizino'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => esc_html__("GET AND AMAZING", 'bizino'),
                'description'   => esc_html__('enter tab details title', 'bizino')
            ]
        );
        $repeater->add_control(
            'tab_details_title', [
                'label'         => esc_html__('Tab Details Title', 'bizino'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => esc_html__("Get Right Solution for Your Business", 'bizino'),
                'description'   => esc_html__('enter tab details title', 'bizino')
            ]
        );
        $repeater->add_control(
            'tab_details_info', [
                'label'         => esc_html__('Tab Details Info', 'bizino'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => esc_html__("You can’t build a strong business without investing time and money into it. You’ll also need to promote your business and establish...", 'bizino'),
                'description'   => esc_html__('enter tab details info', 'bizino')
            ]
        );
        $repeater->add_control(
            'tab_details_list1', [
                'label'             => esc_html__('Tab Details List 1', 'bizino'),
                'type'              => Controls_Manager::TEXTAREA,
                'default'           => esc_html__("Easy To Connect With Customer", 'bizino'),
                'description'       => esc_html__('enter tab details List', 'bizino')
            ]
        );
        $repeater->add_control(
            'tab_details_list2', [
                'label'             => esc_html__('Tab Details List 2', 'bizino'),
                'type'              => Controls_Manager::TEXTAREA,
                'default'           => esc_html__("Interactive Growing Company From Startup", 'bizino'),
                'description'       => esc_html__('enter tab details List', 'bizino')
            ]
        );
        $repeater->add_control(
            'tab_details_list3', [
                'label'         => esc_html__('Tab Details List 3', 'bizino'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => esc_html__("Manage Your Business & Guide To Build", 'bizino'),
                'description'   => esc_html__('enter tab details List', 'bizino')
            ]
        );
        $repeater->add_control(
            'btn_text', [
                'label'         => esc_html__('Button Text', 'bizino'),
                'type'          => Controls_Manager::TEXT,
                'default'       => esc_html__('Learn More', 'bizino'),
                'description'   => esc_html__('enter button text', 'bizino'),
            ]
        );
        $repeater->add_control(
            'btn_link', [
                'label' => esc_html__('Button URL', 'bizino'),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#'
                ],
                'description' => esc_html__('enter button url', 'bizino'),
            ]
        );

        $this->add_control(
            'tab_list',
            [
                'label' => __('Slides', 'bizino'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tab_title' => __('Our Mission', 'bizino'),
                    ],
                    [
                        'tab_title' => __('Our Vision', 'bizino'),
                    ],
                    [
                        'tab_title' => __('Our Goals', 'bizino'),
                    ],
                ],
                'title_field' => '{{{ tab_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'general_style',
            [
                'label' => __('General', 'bizino'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label'     => __('Button Text Color', 'bizino'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-tab button' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_text_color_hover',
            [
                'label'     => __('Button Text Color Hover', 'bizino'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-tab button:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_activebg_color',
            [
                'label'     => __('Button Active Bg Color', 'bizino'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-tab button.active' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_activebg_textcolor',
            [
                'label'     => __('Button Active Text Color', 'bizino'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-tab button.active' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_border_color',
            [
                'label'     => __('Border Color', 'bizino'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-tab' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .about-tab button:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'list_textcolor',
            [
                'label'     => __('List Text Color', 'bizino'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .list-style7 li' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'post_title_style_section',
            [
                'label' => __('Title', 'bizino'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'post_title_color',
            [
                'label' => __('Title Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-title5' => 'color: {{VALUE}}!important',
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_title_typography',
                'label' => __('Title Typography', 'bizino'),
                'selector' => '{{WRAPPER}} .sec-title5',
            ]
        );

        $this->add_responsive_control(
            'post_title_margin',
            [
                'label' => __('Title Margin', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .sec-title5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'post_title_padding',
            [
                'label' => __('Title Padding', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .sec-title5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'post_subtitle_style_section',
            [
                'label' => __('Sub Title', 'bizino'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'post_subtitle_color',
            [
                'label' => __('Sub Title Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sec-subtitle5' => 'color: {{VALUE}}!important',
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_subtitle_typography',
                'label' => __('Sub Title Typography', 'bizino'),
                'selector' => '{{WRAPPER}} sec-subtitle5',
            ]
        );

        $this->add_responsive_control(
            'post_subtitle_margin',
            [
                'label' => __('Sub Title Margin', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .sec-subtitle5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'post_subtitle_padding',
            [
                'label' => __('Sub Title Padding', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .sec-subtitle5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'post_desc_style_section',
            [
                'label' => __('Description', 'bizino'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'post_desc_color',
            [
                'label' => __('Description Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-box4 p' => 'color: {{VALUE}}!important',
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'post_desc_typography',
                'label' => __('Description Typography', 'bizino'),
                'selector' => '{{WRAPPER}} .about-box4 p',
            ]
        );

        $this->add_responsive_control(
            'post_desc_margin',
            [
                'label' => __('Description Margin', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .about-box4 p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'post_desc_padding',
            [
                'label' => __('Description Padding', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .about-box4 p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();
        ?>
        <!--==============================
        About Us
        ==============================-->
        <div class="nav about-tab" id="nav-tab" role="tablist">
            <?php if ($settings['tab_list']) {
                $tab_btn = 0;
                foreach ($settings['tab_list'] as $tab) {
                    $tab_btn++;
                    if ($tab_btn == 1) {
                        $btn_act = 'active';
                        $btn_true = 'true';
                    } else {
                        $btn_act = '';
                        $btn_true = 'false';
                    }
                    ?>
                    <button class="nav-link <?php echo esc_attr($btn_act); ?>"
                            id="<?php echo esc_attr($tab['_id']); ?>-tab" data-bs-toggle="tab"
                            data-bs-target="#work<?php echo esc_attr($tab['_id']); ?>"
                            type="button" role="tab" aria-controls="work<?php echo esc_attr($tab['_id']); ?>"
                            aria-selected="<?php echo esc_attr($btn_true); ?>">
                        <?php echo esc_html($tab['tab_title']); ?>
                    </button>
                <?php }
            } ?>
        </div>
        <div class="tab-content" id="nav-tabContent">
            <?php if ($settings['tab_list']) {
                $tabs = 0;
                foreach ($settings['tab_list'] as $tab) {
                    $tabs++;
                    if ($tabs == 1) {
                        $tab_act = 'show active';
                    } else {
                        $tab_act = '';
                    }
                    ?>
                    <div class="tab-pane fade <?php echo esc_attr($tab_act); ?>"
                         id="work<?php echo esc_attr($tab['_id']); ?>" role="tabpanel"
                         aria-labelledby="<?php echo esc_attr($tab['_id']); ?>-tab">
                        <div class="row">
                            <div class="col-lg-6">
                                <img src="<?php echo esc_attr($tab['tab_thumb_image']['url']); ?>" alt="about image" class="w-100">
                            </div>
                            <div class="col-lg-6 align-self-center">
                                <div class="about-box4">
                                    <span class="sec-subtitle5"><?php echo esc_html($tab['tab_details_subtitle']); ?></span>
                                    <h2 class="sec-title5"><?php echo esc_html($tab['tab_details_title']); ?></h2>
                                    <p class="fs-md mb-4 pb-2"><?php echo esc_html($tab['tab_details_info']); ?></p>
                                    <div class="list-style7 ">
                                        <ul>
                                            <?php
                                                if( ! empty( $tab['tab_details_list1'] ) ):
                                            ?>
                                            <li>
                                                <i class="fal fa-check"></i><?php echo esc_html($tab['tab_details_list1']); ?>
                                            </li>
                                            <?php
                                                endif;
                                                if( ! empty( $tab['tab_details_list2'] ) ):
                                            ?>
                                            <li>
                                                <i class="fal fa-check"></i><?php echo esc_html($tab['tab_details_list2']); ?>
                                            </li>
                                            <?php
                                                endif;
                                                if( ! empty( $tab['tab_details_list3'] ) ):
                                            ?>
                                            <li>
                                                <i class="fal fa-check"></i><?php echo esc_html($tab['tab_details_list3']); ?>
                                            </li>
                                            <?php endif;?>
                                        </ul>
                                    </div>
                                    <?php if( ! empty( $tab['btn_text'] ) ):?>
                                    <a href="<?php echo esc_url($tab['btn_link']['url']); ?>"
                                       class="vs-btn"><?php echo esc_html($tab['btn_text']); ?></a>
                                       <?php endif;?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php }
            } ?>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register(new Bizino_Working_Process());