<?php
    use Elementor\Controls_Manager;
    use Elementor\Group_Control_Box_Shadow;
    use Elementor\Group_Control_Typography;
    use Elementor\Plugin;
    use Elementor\Repeater;
    use Elementor\Utils;
    use Elementor\Widget_Base;

/**
 *
 * Testimonial Slider Widget .
 *
 */
class Bizino_New_Testimonial_Slider extends Widget_Base
{

    public function get_name(){
        return 'bizinonewtestimonialslider';
    }

    public function get_title(){
        return __( 'New Testimonial Slider', 'bizino' );
    }

    public function get_icon(){
        return 'eicon-code';
    }

    public function get_categories(){
        return ['bizino'];
    }

    protected function register_controls(){

        $this->start_controls_section(
            'testimonial_slider_section',
            [
                'label'     => __('Testimonial Slider', 'bizino'),
                'tab'       => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'client_image',
            [
                'label' => __('Client Image', 'bizino'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'client_feedback', [
                'label'         => __( 'Client Feedback', 'bizino' ),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __('“We think your skin should look and refshed matter Nourish your outer inner beauty with our essential oil infused beauty products”', 'bizino'),
                'label_block'   => true,
            ]
        );
        $repeater->add_control(
            'client_name', [
                'label'         => __('Client Name', 'bizino'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __('Rubaida Kanom', 'bizino'),
                'label_block'   => true,
            ]
        );
        $repeater->add_control(
            'client_designation', [
                'label'         => __('Client Designation', 'bizino'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __('Chef Leader', 'bizino'),
                'label_block'   => true,
            ]
        );

        $this->add_control(
            'slides',
            [
                'label'     => __('Slides', 'bizino'),
                'type'      => Controls_Manager::REPEATER,
                'fields'    => $repeater->get_controls(),
                'default'   => [
                    [
                        'client_name'       => __('Marko Polo', 'bizino'),
                        'client_feedback'   => __('“We think your skin should look and refshed matter Nourish your outer inner beauty with our essential oil infused beauty products”', 'bizino'),
                        'client_image'      => Utils::get_placeholder_image_src(),
                    ],
                    [
                        'client_name'       => __('Vivi Marian', 'bizino'),
                        'client_feedback'   => __('“We think your skin should look and refshed matter Nourish your outer inner beauty with our essential oil infused beauty products”', 'bizino'),
                        'client_image'      => Utils::get_placeholder_image_src(),
                    ],
                    [
                        'client_name'       => __('Thomas Muller', 'bizino'),
                        'client_feedback'   => __('“We think your skin should look and refshed matter Nourish your outer inner beauty with our essential oil infused beauty products”', 'bizino'),
                        'client_image'      => Utils::get_placeholder_image_src(),
                    ],
                ],
                'title_field'   => '{{{ client_name }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'slider_control_section',
            [
                'label' => __('Slider Control', 'bizino'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'slider_arrows',
            [
                'label' => __('Arrows', 'bizino'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'bizino'),
                'label_off' => __('No', 'bizino'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'testimonial_general',
            [
                'label' => __('General', 'bizino'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'testimonial_rating_color',
            [
                'label' => __('Testimonial Star Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .star-rating span:before' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'testimonial_slider_client_name_style_section',
            [
                'label' => __('Client Name', 'bizino'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'testimonial_slider_client_name_color',
            [
                'label' => __('Client Name Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testi-slide2 .testi-name' => 'color: {{VALUE}}!important',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'testimonial_slider_client_name_typography',
                'label' => __('Client Name Typography', 'bizino'),
                'selector' => '{{WRAPPER}} .testi-slide2 .testi-name',
            ]
        );

        $this->add_responsive_control(
            'testimonial_slider_client_name_margin',
            [
                'label' => __('Client Name Margin', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .testi-slide2 .testi-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'testimonial_slider_client_name_padding',
            [
                'label' => __('Client Name Padding', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .testi-slide2 .testi-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'testimonial_slider_client_feedback_style_section',
            [
                'label' => __('Client Feedback', 'bizino'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'testimonial_slider_client_feedback_color',
            [
                'label' => __('Client Feedback Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testi-style2 .testi-text' => 'color: {{VALUE}} !important',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'testimonial_slider_client_feedback_typography',
                'label' => __('Client Feedback Typography', 'bizino'),
                'selector' => '{{WRAPPER}} .testi-style2 .testi-text',
            ]
        );

        $this->add_responsive_control(
            'testimonial_slider_client_feedback_margin',
            [
                'label' => __('Client Feedback Margin', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .testi-style2 .testi-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'testimonial_slider_client_feedback_padding',
            [
                'label' => __('Client Feedback Padding', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .testi-style2 .testi-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'testimonial_slider_designation_style_section',
            [
                'label' => __('Designation', 'bizino'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'testimonial_slider_designation_color',
            [
                'label' => __('Client Designation Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testi-style2 .testi-degi' => 'color: {{VALUE}}!important',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'testimonial_slider_designation_typography',
                'label' => __('Client Designation Typography', 'bizino'),
                'selector' => '{{WRAPPER}} .testi-style2 .testi-degi',
            ]
        );

        $this->add_responsive_control(
            'testimonial_slider_designation_margin',
            [
                'label' => __('Client Designation Margin', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .testi-style2 .testi-degi' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'testimonial_slider_designation_padding',
            [
                'label' => __('Client Designation Padding', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .testi-style2 .testi-degi' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
            ]
        );

        $this->end_controls_section();

    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();

        $this->add_render_attribute('wrapper', 'class', 'vs-carousel testi-slide2');
        $this->add_render_attribute('wrapper', 'data-fade', 'true');
        $this->add_render_attribute('wrapper', 'data-slide-show', '1');
        $this->add_render_attribute('wrapper', 'data-arrows', 'true');

        if ( ! empty( $settings['slides'] ) ) {
            echo '<div '.$this->get_render_attribute_string( 'wrapper' ).'>';
                foreach( $settings['slides'] as $singleslide ){
                    echo '<div>';
                        echo '<div class="testi-style5">';
                            if( ! empty( $singleslide['client_image']['url'] ) ){
                                echo '<div class="testi-avater">';
                                    echo techbiz_img_tag( array(
                                        'url'   =>  esc_url( $singleslide['client_image']['url'] )
                                    ) );
                                echo '</div>';
                            }
                            if( ! empty( $singleslide['client_feedback'] ) ){
                                echo '<p class="testi-text text-white">'.esc_html( $singleslide['client_feedback'] ).'</p>';
                            }
                            echo '<div class="testi-shape text-white"><span class="arrow"></span><span class="arrow"></span><span class="arrow"></span><span class="arrow"></span></div>';
                            if( ! empty( $singleslide['client_name'] ) ){
                                echo '<h3 class="testi-name text-white">'.esc_html( $singleslide['client_name'] ).'</h3>';
                            }
                            if( ! empty( $singleslide['client_designation'] ) ){
                                echo '<span class="testi-degi text-white">'.esc_html( $singleslide['client_designation'] ).'</span>';
                            }
                        echo '</div>';
                    echo '</div>';
                }
            echo '</div>';
        }
    }
}

Plugin::instance()->widgets_manager->register( new Bizino_New_Testimonial_Slider() );