<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Widget_Base;

/**
 *
 * Team Widget .
 *
 */
class Bizino_New_Team_Widget extends Widget_Base{

    public function get_name(){
        return 'bizinonewteammember';
    }

    public function get_title(){
        return __( 'Bizino New Team', 'bizino' );
    }

    public function get_icon(){
        return 'eicon-user-circle-o';
    }

    public function get_categories(){
        return ['bizino'];
    }

    protected function register_controls(){

        $this->start_controls_section(
            'team_content',
            [
                'label' => __('Team', 'bizino'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'team_style',
            [
                'label'     => __( 'Team Style', 'bizino' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => '1',
                'options'   => [
                    '1'         => __( 'Slider Style', 'bizino' ),
                    '2'         => __( 'Grid Style', 'bizino' ),
                ],
            ]
        );

        $repeater = new Repeater();
        
        $repeater->add_control(
            'team_image',
            [
                'label'         => esc_html__('Team Image', 'bizino'),
                'type'          => Controls_Manager::MEDIA,
                'default'       => [
                    'url'   => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $repeater->add_control(
            'designation', [
                'label'         => __('Designation', 'bizino'),
                'type'          => Controls_Manager::TEXT,
                'default'       => __('Customer', 'bizino'),
                'label_block'   => true,
            ]
        );
        $repeater->add_control(
            'name', [
                'label'         => __('Name', 'bizino'),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __('Rodja Hartmann', 'bizino'),
                'rows'          => 2,
                'label_block'   => true,
            ]
        );
        
        $repeater->add_control(
            'phone', [
                'label'         => __( 'Contact Number', 'bizino' ),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __( 'Customer', 'bizino' ),
                'label_block'   => true,
            ]
        );
        
        $repeater->add_control(
            'email', [
                'label'         => __( 'Email', 'bizino' ),
                'type'          => Controls_Manager::TEXTAREA,
                'default'       => __( 'Email', 'bizino' ),
                'label_block'   => true,
            ]
        );
        
        $repeater->add_control(
            'profile_link',
            [
                'label'         => esc_html__('Profile Link', 'bizino'),
                'type'          => Controls_Manager::URL,
                'placeholder'   => esc_html__('https://your-link.com', 'bizino'),
                'show_external' => true,
                'default'       => [
                    'url'           => '#',
                    'is_external'   => false,
                    'nofollow'      => false,
                ],
            ]
        );
        
        $this->add_control(
            'team_members',
            [
                'label'     => __('Team Member', 'bizino'),
                'type'      => Controls_Manager::REPEATER,
                'fields'    => $repeater->get_controls(),
                'default'   => [
                    [
                        'name' => __( 'Rodja Hartmann', 'bizino' ),
                    ],
                ],
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'slider_control_section',
            [
                'label' => __('Slider Control', 'bizino'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'slide_to_show',
            [
                'label' => __('Slide To Show', 'bizino'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 4,
                ],
            ]
        );
        $this->add_control(
            'slide_lg_to_show',
            [
                'label' => __('Slide Md To Show', 'bizino'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 3,
                ],
            ]
        );
        $this->add_control(
            'slide_md_to_show',
            [
                'label' => __('Slide Sm To Show', 'bizino'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 2,
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'title_styling',
            [
                'label' => __('Title Styling', 'bizino'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-style4 .team-name' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'title_hvr_color',
            [
                'label' => __('Title Hover Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-style4 .team-name a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', 'bizino'),
                'selector' => '{{WRAPPER}} .team-style4 .team-name'
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __('Title Margin', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .team-style4 .team-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __('Title Padding', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .team-style4 .team-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        /*-----------------------------------------designation styling------------------------------------*/

        $this->start_controls_section(
            'degi_styling',
            [
                'label' => __('Designation Styling', 'bizino'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'degi_color',
            [
                'label' => __('Designation Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-style4 .team-degi' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'degi_hvr_color',
            [
                'label' => __('Designation Hover Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-style4 .team-degi:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'degi_typography',
                'label' => __('Designation Typography', 'bizino'),
                'selector' => '{{WRAPPER}} .team-style4 .team-degi'
            ]
        );

        $this->add_responsive_control(
            'degi_margin',
            [
                'label' => __('Designation Margin', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .team-style4 .team-degi' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'degi_padding',
            [
                'label' => __('Designation Padding', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .team-style4 .team-degi' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        /*-----------------------------------------contact styling------------------------------------*/

        $this->start_controls_section(
            'contact_styling',
            [
                'label' => __('Contact Styling', 'bizino'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'contact_color',
            [
                'label' => __('Contact Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-style4 .team-number,{{WRAPPER}} .team-style4 .team-email' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'contact_hvr_color',
            [
                'label' => __('Contact Number Hover Color', 'bizino'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-style4 .team-number:hover,{{WRAPPER}} .team-style4 .team-email:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'contact_typography',
                'label' => __('Contact Number Typography', 'bizino'),
                'selector' => '{{WRAPPER}} .team-style4 .team-number,{{WRAPPER}} .team-style4 .team-email'
            ]
        );

        $this->add_responsive_control(
            'contact_margin',
            [
                'label' => __('Contact Number Margin', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .team-style4 .team-number,{{WRAPPER}} .team-style4 .team-email' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'contact_padding',
            [
                'label' => __('Contact Number Padding', 'bizino'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .team-style4 .team-number,{{WRAPPER}} .team-style4 .team-email' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render(){

        $settings = $this->get_settings_for_display();
        
        if ( $settings['team_style'] == '1' ) {
            $this->add_render_attribute( 'wrapper', 'class', 'row vs-carousel' );
            $this->add_render_attribute( 'wrapper', 'data-slide-show', $settings['slide_to_show']['size'] );
            $this->add_render_attribute( 'wrapper', 'data-lg-slide-show', $settings['slide_lg_to_show']['size'] );
            $this->add_render_attribute( 'wrapper', 'data-md-slide-show', $settings['slide_md_to_show']['size'] );
        } else {
            $this->add_render_attribute( 'wrapper', 'class', 'row' );
        }
        
        echo '<div class="team-section">';
            echo '<div class="container">';
                echo '<div '.$this->get_render_attribute_string('wrapper').'>';
                    foreach( $settings['team_members'] as $singleslide ) {
                        $mobile     = $singleslide['phone'];
                        $email      = is_email( $singleslide['email'] );
                        
                        $replace    = array(' ', '-', ' - ');
                        $with       = array('', '', '');
                        $mobileurl  = str_replace( $replace, $with, $mobile );
                        $emailurl   = str_replace( $replace, $with, $email );
                        echo '<div class="col-md-6 col-lg-4 col-xl-3">';
                            echo '<div class="team-style4">';
                                if( ! empty( $singleslide['team_image']['url'] ) ){
                                    echo '<div class="team-img">';
                                        echo techbiz_img_tag( array(
                                            'url'   => esc_url( $singleslide['team_image']['url'] )
                                        ) );
                                    echo '</div>';
                                }
                                if( ! empty( $singleslide['designation'] ) ){
                                    echo '<span class="team-degi">'.esc_html( $singleslide['designation'] ).'</span>';
                                }
                                if( ! empty( $singleslide['name'] ) ){
                                    echo '<h3 class="team-name h5">';
                                        echo '<a href="'.esc_url( $singleslide['profile_link']['url'] ).'" class="text-inherit">'.esc_html( $singleslide['name'] ).'</a>';
                                    echo '</h3>';
                                }
                                if( ! empty( $email ) ){
                                    echo '<a href="mailto:'.esc_attr( $emailurl ).'" class="team-email">'.esc_html( $email ).'</a>';
                                }
                                if( ! empty( $mobile ) ){
                                    echo '<a href="tel:'.esc_attr( $mobileurl ).'" class="team-number">'.esc_html( $mobile ).'</a>';
                                }
                                if( ! empty( $singleslide['profile_link']['url'] ) ){
                                    echo '<a href="'.esc_url( $singleslide['profile_link']['url'] ).'" class="team-btn"><i class="far fa-long-arrow-right"></i></a>';
                                }
                            echo '</div>';
                      echo '</div>';
                    }
                echo '</div>';
            echo '</div>';
        echo '</div>';
    }
}

Plugin::instance()->widgets_manager->register( new Bizino_New_Team_Widget() );