<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
use \Elementor\Plugin;
/**
 *
 * New Header Widget .
 *
 */
class Bizino_Menu_Area extends Widget_Base {

	public function get_name() {
		return 'bizinomenuarea';
	}

	public function get_title() {
		return __( 'Bizino Menu Area', 'bizino' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'bizino_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'header_section',
			[
				'label' 	=> __( 'Header', 'bizino' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        
        $this->add_control(
			'phone_number_text',
			[
				'label' 	=> __( 'Phone Number text', 'bizino' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'NEED HELP NOW?', 'bizino' )
			]
        );
        
        $this->add_control(
			'phone_number',
			[
				'label' 	=> __( 'Phone Number', 'bizino' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( '+ 1 333 555 999', 'bizino' )
			]
        );
        
        $this->add_control(
			'placeholder_text',
			[
				'label' 	=> __( 'Search Placeholder Text', 'bizino' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Search Here...', 'bizino' )
			]
        );
        
        $this->end_controls_section();

		$this->start_controls_section(
			'menu_top_level_menu_item_style_section',
			[
				'label' 	=> __( 'Top Level Menu Items', 'bizino' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
			'top_level_menu_color',
			[
				'label' 		=> __( 'Menu Color', 'bizino' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .menu-style4 > ul > li > a' => 'color: {{VALUE}} !important;',
                ]
			]
        );

        $this->add_control(
			'top_level_menu_hover_color',
			[
				'label' 			=> __( 'Menu Hover Color', 'bizino' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .menu-style4 > ul > li > a:hover' => 'color: {{VALUE}} !important;',
                ]
			]
        );

        $this->add_control(
			'top_level_menu_bg_color',
			[
				'label' 			=> __( 'Menu Background Color', 'bizino' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .menu-style4 > ul > li > a' => 'background-color: {{VALUE}} !important;',
                ]
			]
		);

		$this->add_control(
			'top_level_menu_hover_bg_color',
			[
				'label' 		=> __( 'Menu Hover Background Color', 'bizino' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .menu-style4 > ul > li > a:hover' => 'background-color: {{VALUE}} !important;',
                ]
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'top_level_menu_typography',
				'label' 		=> __( 'Menu Typography', 'bizino' ),
                'selector' 		=> '{{WRAPPER}} .menu-style4 > ul > li > a',
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'top_level_menu_typography_hover',
				'label' 		=> __( 'Menu Typography Hover', 'bizino' ),
                'selector' 		=> '{{WRAPPER}} .menu-style4 > ul > li > a:hover',
			]
		);

        $this->add_responsive_control(
			'top_level_menu_margin',
			[
				'label' 		=> __( 'Menu Margin', 'bizino' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .menu-style4 > ul > li > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
        );

        $this->add_responsive_control(
			'top_level_menu_padding',
			[
				'label' 		=> __( 'Menu Padding', 'bizino' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .menu-style4 > ul > li > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'top_level_menu_border',
				'label' 	=> __( 'Border', 'bizino' ),
				'selector' 	=> '{{WRAPPER}} .menu-style4 > ul > li > a',
			]
		);

		$this->end_controls_section();


    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        
        $mobile     = $settings['phone_number'];

        $replace    = array(' ', '-', ' - ');
        $with       = array('', '', '');

        $mobileurl  = str_replace($replace, $with, $mobile);
        
        echo '<div class="vs-header header-layout11">';
            echo '<div class="menu-area d-none d-lg-block">';
                echo '<div class="container-xl">';
                    echo '<div class="row gx-0 align-items-center justify-content-between">';
                        echo '<div class="col">';
                            echo '<div class="row justify-content-between align-items-center inner-wrap gx-0">';
                                echo '<div class="col-auto">';
                                    echo '<nav class="main-menu menu-style7 d-none d-lg-block">';
                                    if( has_nav_menu( 'primary-menu' ) ){
																			wp_nav_menu( array(
																					"theme_location"    => 'primary-menu',
																					"container"         => '',
																					"menu_class"        => ''
																			) );
                                    }
                                    echo '</nav>';
                                echo '</div>';
                                echo '<div class="col-auto">';
                                    echo '<button class="icon-btn searchBoxTggler style5"><i class="far fa-search"></i></button>';
                                echo '</div>';
                            echo '</div>';
                        echo '</div>';
                        echo '<div class="col-auto">';
                            echo '<div class="media-style1 layout2">';
                                echo '<div class="media-icon"><i class="fas fa-headset"></i></div>';
                                echo '<div class="media-body">';
                                    if( ! empty( $settings['phone_number_text'] ) ){
                                        echo '<span class="media-label">'.esc_html( $settings['phone_number_text'] ).'</span>';
                                    }
                                    if( ! empty( $mobile ) ){
                                        echo '<p class="media-info"><a href="tel:'.esc_attr( $mobileurl ).'" class="text-inherit">'.esc_html( $mobile ).'</a></p>';
                                    }
                                echo '</div>';
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        echo '</div>';
		
		echo '<div class="popup-search-box d-none d-sm-block">';
			echo '<button class="searchClose"><i class="fal fa-times"></i></button>';
			echo '<form action="'.esc_url( home_url() ).'">';
				echo '<input type="text" class="border-theme" placeholder="'.esc_attr( $settings['placeholder_text'] ).'">';
				echo '<button type="submit"><i class="fal fa-search"></i></button>';
			echo '</form>';
		echo '</div>';
	}
}
Plugin::instance()->widgets_manager->register(new Bizino_Menu_Area());