<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
/**
 *
 * Testimonial Slider Widget .
 *
 */
class Techbiz_Testimonial_Slider extends Widget_Base{

	public function get_name() {
		return 'techbiztestimonialslider';
	}

	public function get_title() {
		return __( 'Testimonial Slider', 'techbiz' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'techbiz' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'testimonial_slider_section',
			[
				'label' 	=> __( 'Testimonial Slider', 'techbiz' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'testimonial_style',
			[
				'label' 		=> __( 'Testimonial Style', 'techbiz' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  			=> __( 'Style One', 'techbiz' ),
					'2' 			=> __( 'Style Two', 'techbiz' ),
					'3' 			=> __( 'Style Three', 'techbiz' ),
					'4' 			=> __( 'Style Four', 'techbiz' ),
				],
			]
		);

		$this->add_control(
			'subtitle', [
				'label' 		=> __( 'Section Subtitle', 'techbiz' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'OUR BEST REVIEW’S' , 'techbiz' ),
				'label_block' 	=> true,
				'condition'		=> [ 'testimonial_style' => ['1','2'] ]
			]
        );
		$this->add_control(
			'title', [
				'label' 		=> __( 'Section Title', 'techbiz' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'CUSTOMER’S FEEDBACK' , 'techbiz' ),
				'label_block' 	=> true,
				'condition'		=> [ 'testimonial_style' => ['1','2'] ]
			]
        );

		$repeater = new Repeater();

		$repeater->add_control(
			'client_image',
			[
				'label' 		=> __( 'Client Image', 'techbiz' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'client_big_image',
			[
				'label' 		=> __( 'Client Big Image', 'techbiz' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'client_name', [
				'label' 		=> __( 'Client Name', 'techbiz' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Rubaida Kanom' , 'techbiz' ),
				'label_block' 	=> true,
			]
        );
		$repeater->add_control(
			'client_designation', [
				'label' 		=> __( 'Client Designation', 'techbiz' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Chef Leader' , 'techbiz' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'client_feedback_title', [
				'label' 		=> __( 'Client Feedback Title', 'techbiz' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'From its medieval origins to the digital era, learn everything about passage' , 'techbiz' ),
				'label_block' 	=> true,
			]
		);
        $repeater->add_control(
			'client_feedback', [
				'label' 		=> __( 'Client Feedback', 'techbiz' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Contrary to popular belief, Lorem Ipsum is not simply random text over 2000 years old. Richard McClintock' , 'techbiz' ),
				'label_block' 	=> true,
			]
		);

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'techbiz' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'client_name' 		=> __( 'Marko Polo', 'techbiz' ),
						'client_feedback' 	=> __( 'Contrary to popular belief, Lorem Ipsum is not simply random text over 2000 years old. Richard McClintock', 'techbiz' ),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
					[
						'client_name' 		=> __( 'Vivi Marian', 'techbiz' ),
						'client_feedback' 	=> __( 'Contrary to popular belief, Lorem Ipsum is not simply random text over 2000 years old. Richard McClintock', 'techbiz' ),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
					[
						'client_name' 		=> __( 'Customer', 'techbiz' ),
						'client_feedback' 	=> __( 'Contrary to popular belief, Lorem Ipsum is not simply random text over 2000 years old. Richard McClintock', 'techbiz' ),
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{{ client_name }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'techbiz' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );
		$this->add_control(
			'slide_to_show',
			[
				'label' 		=> __( 'Slide To Show', 'techbiz' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 10,
						'step'			=> 1,
					],
				],
				'default' 	=> [
					'unit' 		=> 'px',
					'size' 		=> 3,
				],
			]
		);
		$this->add_control(
			'slider_arrows',
			[
				'label' 		=> __( 'Arrows', 'techbiz' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'techbiz' ),
				'label_off' 	=> __( 'No', 'techbiz' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'testimonial_general',
			[
				'label' 	=> __( 'General', 'techbiz' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'active_author_box_bg_color',
			[
				'label' 		=> __( 'Active Author Box Background Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .author-slide-box:hover, .slick-current.author-slide-box' => 'background-color: {{VALUE}}',
				],
				'condition'		=> [ 'testimonial_style'	=> '1' ]
			]
		);

		$this->add_control(
			'author_box_bg_color',
			[
				'label' 		=> __( 'Author Box Background Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .author-slide-box' => 'background-color: {{VALUE}}',
				],
				'condition'		=> [ 'testimonial_style'	=> '1' ]
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' 			=> 'background',
				'label' 		=> __( 'Background', 'techbiz' ),
				'types' 		=> [ 'classic', 'gradient', 'video' ],
				'selector' 		=> '{{WRAPPER}} .testimonial-inner',
				'condition'		=> [ 'testimonial_style'	=> '1' ]
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' 		=> 'box_shadow',
				'label' 	=> __( 'Box Shadow', 'techbiz' ),
				'selector' 	=> '{{WRAPPER}} .testimonial-inner',
				'condition'		=> [ 'testimonial_style'	=> '1' ]
			]
		);

		$this->add_control(
			'testimonial_icon_color',
			[
				'label' 		=> __( 'Testimonial Icon Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-box .quote,{{WRAPPER}} .testimonial-style1 .quote-icon i' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'testimonial_rating_color',
			[
				'label' 		=> __( 'Testimonial Star Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .star-rating span:before' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'testimonial_arrow_color',
			[
				'label' 		=> __( 'Testimonial Arrow Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .author-slide-arrow i' => 'color: {{VALUE}}!important',
				],
				'condition'		=> [ 'testimonial_style'	=> '1' ]
			]
		);
		$this->add_control(
			'testimonial_arrow_hover_color',
			[
				'label' 		=> __( 'Testimonial Arrow Hover Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .author-slide-arrow:hover i' => 'color: {{VALUE}}!important',
				],
				'condition'		=> [ 'testimonial_style'	=> '1' ]
			]
		);
		$this->add_control(
			'testimonial_arrow_bg',
			[
				'label' 		=> __( 'Testimonial Arrow Background Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .author-slide-arrow button' => 'background-color: {{VALUE}}',
				],
				'condition'		=> [ 'testimonial_style'	=> '1' ]
			]
		);
		$this->add_control(
			'testimonial_arrow_hover_bg',
			[
				'label' 		=> __( 'Testimonial Arrow Hover Background Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .author-slide-arrow button:hover' => 'background-color: {{VALUE}}!important',
				],
				'condition'		=> [ 'testimonial_style'	=> '1' ]
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
			'testimonial_slider_client_name_style_section',
			[
				'label' 	=> __( 'Client Name', 'techbiz' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'testimonial_slider_client_name_color',
			[
				'label' 		=> __( 'Client Name Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .author-slide-box .author-name,{{WRAPPER}} .author-pill-box .author-info h5,{{WRAPPER}} .testi-style4 .testi-name' => 'color: {{VALUE}}!important',
				],
			]
        );

        $this->add_control(
			'testimonial_slider_active_client_name_color',
			[
				'label' 		=> __( 'Active Client Name Color', 'techbiz' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .slick-current.author-slide-box .author-name,{{WRAPPER}} .testi-style4 .testi-name' => 'color: {{VALUE}}',
				],
				'condition'		=> [ 'testimonial_style'	=> '1' ]
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'testimonial_slider_client_name_typography',
				'label' 	=> __( 'Client Name Typography', 'techbiz' ),
				'selector' 	=> '{{WRAPPER}} .author-slide-box .author-name,{{WRAPPER}} .author-pill-box .author-info h5,{{WRAPPER}} .testi-style4 .testi-name',
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_client_name_margin',
			[
				'label' 		=> __( 'Client Name Margin', 'techbiz' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .author-slide-box .author-name,{{WRAPPER}} .author-pill-box .author-info h5,{{WRAPPER}} .testi-style4 .testi-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_client_name_padding',
			[
				'label' 		=> __( 'Client Name Padding', 'techbiz' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .author-slide-box .author-name,{{WRAPPER}} .author-pill-box .author-info h5,{{WRAPPER}} .testi-style4 .testi-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'testimonial_slider_client_feedback_style_section',
			[
				'label' 	=> __( 'Client Feedback', 'techbiz' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'testimonial_slider_client_feedback_color',
			[
				'label' 	=> __( 'Client Feedback Color', 'techbiz' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testi-text,{{WRAPPER}} .testimonial-style1 .media-body p' => 'color: {{VALUE}} !important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'testimonial_slider_client_feedback_typography',
				'label' 	=> __( 'Client Feedback Typography', 'techbiz' ),
				'selector' 	=> '{{WRAPPER}} .testi-text,{{WRAPPER}} .testimonial-style1 .media-body p',
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_client_feedback_margin',
			[
				'label' 		=> __( 'Client Feedback Margin', 'techbiz' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-text,{{WRAPPER}} .testimonial-style1 .media-body p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_client_feedback_padding',
			[
				'label' 		=> __( 'Client Feedback Padding', 'techbiz' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-text,{{WRAPPER}} .testimonial-style1 .media-body p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'testimonial_slider_designation_style_section',
			[
				'label' 	=> __( 'Designation', 'techbiz' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'testimonial_slider_designation_color',
			[
				'label' 	=> __( 'Client Designation Color', 'techbiz' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .author-slide-box .author-degi,{{WRAPPER}} .author-info span,{{WRAPPER}} .testi-style4 .testi-degi' => 'color: {{VALUE}}!important',
				],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'testimonial_slider_designation_typography',
				'label' 	=> __( 'Client Designation Typography', 'techbiz' ),
				'selector' 	=> '{{WRAPPER}} .author-slide-box .author-degi,{{WRAPPER}} .author-info span,{{WRAPPER}} .testi-style4 .testi-degi',
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_designation_margin',
			[
				'label' 		=> __( 'Client Designation Margin', 'techbiz' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .author-slide-box .author-degi,{{WRAPPER}} .author-info span,{{WRAPPER}} .testi-style4 .testi-degi' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'testimonial_slider_designation_padding',
			[
				'label' 		=> __( 'Client Designation Padding', 'techbiz' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .author-slide-box .author-degi,{{WRAPPER}} .author-info span,{{WRAPPER}} .testi-style4 .testi-degi' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();


	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		if( $settings['testimonial_style'] == '1' ){
			$this->add_render_attribute( 'wrapper', 'id', 'testislide1' );
			$this->add_render_attribute( 'wrapper', 'class', 'row vs-carousel style-one' );
		}elseif( $settings['testimonial_style'] == '3' ){
			$this->add_render_attribute( 'wrapper', 'class', 'row testi-style2-slide vs-carousel' );
		}elseif( $settings['testimonial_style'] == '4' ){
			$this->add_render_attribute( 'wrapper', 'class', 'row vs-carousel style-four' );
		}

		$this->add_render_attribute( 'wrapper', 'data-slide-to-show', $settings['slide_to_show']['size'] );

		if( ! empty( $settings['slides'] ) ){
			if( $settings['testimonial_style'] == '1' ){
				echo '<section class="testimonial-wrapper">';
			        echo '<div class="container wow fadeInUp" data-wow-delay="0.2s">';
			            echo '<div class="row justify-content-between">';
			                echo '<div class="col-lg-auto text-center text-lg-start">';
			                    echo '<div class="title-area">';
									if( ! empty( $settings['subtitle'] ) ){
				                        echo '<span class="sec-subtitle"><i class="fas fa-bring-forward"></i>'.esc_html( $settings['subtitle'] ).'</span>';
									}
									if( ! empty( $settings['title'] ) ){
				                        echo '<h2 class="sec-title h1">'.esc_html( $settings['title'] ).'</h2>';
									}
			                    echo '</div>';
			                echo '</div>';
							if( $settings['slider_arrows'] == 'yes' ){
				                echo '<div class="col-auto d-none d-lg-block">';
				                    echo '<div class="sec-btns">';
				                        echo '<button class="vs-btn style4" data-slick-prev="#testislide1"><i class="far fa-arrow-left"></i>Prev</button>';
				                        echo '<button class="vs-btn style4" data-slick-next="#testislide1">Next<i class="far fa-arrow-right"></i></button>';
				                    echo '</div>';
				                echo '</div>';
							}
			            echo '</div>';
			            echo '<div '.$this->get_render_attribute_string('wrapper').'>';
							foreach( $settings['slides'] as $singleslide ) {
								echo '<div class="col-xl-4">';
				                    echo '<div class="testi-style1">';
				                        echo '<div class="testi-icon"><i class="fal fa-quote-right"></i></div>';
										if( ! empty( $singleslide['client_feedback'] ) ){
					                        echo '<p class="testi-text">'.esc_html( $singleslide['client_feedback'] ).'</p>';
										}
										if( ! empty( $singleslide['client_name'] ) ){
					                        echo '<h3 class="testi-name h6">'.esc_html( $singleslide['client_name'] ).'</h3>';
										}
										if( ! empty( $singleslide['client_designation'] ) ){
					                        echo '<div class="testi-degi">'.esc_html( $singleslide['client_designation'] ).'</div>';
										}
				                    echo '</div>';
				                echo '</div>';
							}
			            echo '</div>';
			        echo '</div>';
			    echo '</section>';
			}elseif( $settings['testimonial_style'] == '2' ){
				echo '<section class="testimonial-wrapper">';
			        echo '<div class="container position-relative wow fadeInUp" data-wow-delay="0.2s">';
						if( $settings['slider_arrows'] == 'yes' ){
				            echo '<div class="testimonial-arrow d-none d-xxl-block">';
				                echo '<button class="icon-btn style5" data-slick-prev=".testi-author-slide"><i class="far fa-arrow-left"></i></button>';
				                echo '<button class="icon-btn style5" data-slick-next=".testi-author-slide"><i class="far fa-arrow-right"></i></button>';
				            echo '</div>';
						}
			            echo '<div class="row gx-60">';
			                echo '<div class="col-lg-5 col-xl-6">';
			                    echo '<div class="img-box6 vs-carousel">';
									foreach( $settings['slides'] as $singleslide ) {
										echo '<div>';
				                            echo techbiz_img_tag( array(
												'url'	=> esc_url( $singleslide['client_big_image']['url'] ),
												'class'	=> 'w-100'
											) );
				                        echo '</div>';
									}
			                    echo '</div>';
			                echo '</div>';
			                echo '<div class="col-lg-7 col-xl-6 align-self-end">';
								if( ! empty( $settings['subtitle'] ) ){
				                    echo '<span class="sec-subtitle"><i class="fas fa-bring-forward"></i>'.esc_html( $settings['subtitle'] ).'</span>';
								}
								if( ! empty( $settings['title'] ) ){
				                    echo '<h2 class="sec-title3 h1">'.esc_html( $settings['title'] ).'</h2>';
								}
			                    echo '<div class="testi-text-slide vs-carousel">';
									foreach( $settings['slides'] as $singleslide ) {
										if( ! empty( $singleslide['client_feedback'] ) ){
											echo '<div>';
					                            echo '<p class="testi-text">'.esc_html( $singleslide['client_feedback'] ).'</p>';
					                        echo '</div>';
										}
									}
			                    echo '</div>';
			                    echo '<div class="testi-author-slide row vs-carousel">';
									foreach( $settings['slides'] as $singleslide ) {
										echo '<div class="col">';
				                            echo '<div class="author-style1">';
												if( ! empty( $singleslide['client_image']['url'] ) ){
					                                echo '<div class="author-img">';
														echo techbiz_img_tag( array(
															'url'	=> esc_url( $singleslide['client_image']['url'] )
														) );
													echo '</div>';
												}
				                                echo '<div class="media-body">';
													if( ! empty( $singleslide['client_name'] ) ){
					                                    echo '<h3 class="author-name h6">'.esc_html( $singleslide['client_name'] ).'</h3>';
													}
													if( ! empty( $singleslide['client_designation'] ) ){
					                                    echo '<span class="author-degi">'.esc_html( $singleslide['client_designation'] ).'</span>';
													}
				                                echo '</div>';
				                            echo '</div>';
				                        echo '</div>';
									}
			                    echo '</div>';
			                echo '</div>';
			            echo '</div>';
			        echo '</div>';
			    echo '</section>';
			}elseif( $settings['testimonial_style'] == '3' ){
				echo '<section class="testimonial-wrapper">';
					echo '<div class="container wow fadeInUp" data-wow-delay="0.2s">';
						 echo '<div '.$this->get_render_attribute_string('wrapper').'>';
							foreach( $settings['slides'] as $singleslide ) {
								echo '<div class="col-xl-6">';
				                    echo '<div class="testi-style2">';
				                        echo '<div class="testi-body">';
											if( ! empty( $singleslide['client_image']['url'] ) ){
												echo '<div class="author-img">';
													echo techbiz_img_tag( array(
														'url'	=> esc_url( $singleslide['client_image']['url'] )
													) );
												echo '</div>';
											}
				                            echo '<div class="media-body">';
												if( ! empty( $singleslide['client_feedback'] ) ){
													echo '<p class="testi-text">'.esc_html( $singleslide['client_feedback'] ).'</p>';
												}
				                            echo '</div>';
				                        echo '</div>';
										if( ! empty( $singleslide['client_name'] ) ){
											echo '<h3 class="testi-name">'.esc_html( $singleslide['client_name'] ).'</h3>';
										}
										if( ! empty( $singleslide['client_designation'] ) ){
											echo '<span class="testi-degi">'.esc_html( $singleslide['client_designation'] ).'</span>';
										}
				                    echo '</div>';
				                echo '</div>';
							}
						echo '</div>';
					echo '</div>';
				echo '</section>';
			}elseif( $settings['testimonial_style'] == '4' ){
				echo '<section class="testimonial-wrapper">';
					echo '<div class="container">';
						 echo '<div '.$this->get_render_attribute_string('wrapper').'>';
							foreach( $settings['slides'] as $singleslide ) {
								echo '<div class="col-xl-4">';
			                        echo '<div class="testi-style4">';
			                            echo '<div class="testi-body">';
			                                echo '<div class="author-img">';
												if( ! empty( $singleslide['client_image']['url'] ) ){
													echo techbiz_img_tag( array(
														'url'	=> esc_url( $singleslide['client_image']['url'] )
													) );
												}
			                                    echo '<span class="quote"><i class="fas fa-quote-right"></i></span>';
			                                echo '</div>';
											if( ! empty( $singleslide['client_feedback'] ) ){
												echo '<p class="testi-text">'.esc_html( $singleslide['client_feedback'] ).'</p>';
											}
											if( ! empty( $singleslide['client_name'] ) ){
												echo '<h3 class="testi-name h5">'.esc_html( $singleslide['client_name'] ).'</h3>';
											}
											if( ! empty( $singleslide['client_designation'] ) ){
												echo '<div class="testi-degi">'.esc_html( $singleslide['client_designation'] ).'</div>';
											}
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
							}
						echo '</div>';
					echo '</div>';
				echo '</section>';
			}
		}
	}
}