<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Service Slider Widget .
 *
 */
class Techbiz_Service_Slider extends Widget_Base {

	public function get_name() {
		return 'techbizserviceslider';
	}

	public function get_title() {
		return __( 'Service Slider', 'techbiz' );
	}

	public function get_icon() {
		return 'eicon-code';
    }

	public function get_categories() {
		return [ 'techbiz' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __( 'Service Slider', 'techbiz' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'service_style',
			[
				'label' 	=> __( 'Service Style', 'techbiz' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'techbiz' ),
					'2' 		=> __( 'Style Two', 'techbiz' ),
					'3' 		=> __( 'Style Three', 'techbiz' ),
					'4' 		=> __( 'Style Four', 'techbiz' ),
					'5' 		=> __( 'Style Five', 'techbiz' ),
				],
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'service_image',
			[
				'label' 	=> esc_html__( 'Service Image', 'techbiz' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' 	=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'service_bg_image',
			[
				'label' 	=> esc_html__( 'Service Bg Image', 'techbiz' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' 	=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'service_numbering',
			[
				'label' 	=> __( 'Service Number', 'techbiz' ),
				'type' 		=> Controls_Manager::TEXTAREA,
				'default'   => __( '01', 'techbiz' ),
			]
		);

		$repeater->add_control(
			'service_title',
			[
				'label' 	=> __( 'Service Title', 'techbiz' ),
				'type' 		=> Controls_Manager::TEXTAREA,
				'default'   => __( 'Development Services', 'techbiz' ),
			]
		);

		$repeater->add_control(
			'service_url',
			[
				'label' 	=> __( 'Service Url', 'techbiz' ),
				'type' 		=> Controls_Manager::TEXTAREA,
				'default'   => __( '#', 'techbiz' ),
			]
		);

		$repeater->add_control(
			'service_description',
			[
				'label' 	=> __( 'Service Description', 'techbiz' ),
				'type' 		=> Controls_Manager::TEXTAREA,
				'default'   => __( 'Completely implement via highly efficient process improvements. engage high value before progressive data.', 'techbiz' ),
			]
		);

		$repeater->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'techbiz' ),
				'type' 		=> Controls_Manager::TEXTAREA,
				'default'   => __( 'Read More', 'techbiz' ),
			]
		);

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'techbiz' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'service_title' 		=> __( 'App Development', 'techbiz' ),
						'service_description' 	=> __( 'Seize magnetic before visa alignment network wireless whereas frictionless', 'techbiz' ),
					],
					[
						'service_title' 		=> __( 'IT Solution', 'techbiz' ),
						'service_description' 	=> __( 'Seize magnetic before visa alignment network wireless whereas frictionless', 'techbiz' ),
					],
					[
						'service_title' 		=> __( 'IT Consultant', 'techbiz' ),
						'service_description' 	=> __( 'Seize magnetic before visa alignment network wireless whereas frictionless', 'techbiz' ),
					],
				],
				'title_field' 	=> '{{{ service_title }}}',
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' 		=> __( 'Slider Control', 'techbiz' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'slide_to_show',
			[
				'label' 		=> __( 'Slide To Show', 'techbiz' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 		=> [
					'px' 			=> [
						'min' 			=> 0,
						'max' 			=> 10,
						'step'			=> 1,
					],
				],
				'default' 	=> [
					'unit' 		=> 'px',
					'size' 		=> 3,
				],
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
			'service_style_section',
			[
				'label' => __( 'Service Slider Number Style', 'techbiz' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' 		=> 'background',
				'label' 	=> __( 'Background', 'techbiz' ),
				'types' 	=> [ 'classic', 'gradient', 'video' ],
				'selector' 	=> '{{WRAPPER}} .feature-style2,{{WRAPPER}} .service-style3 .service-back,{{WRAPPER}} .service-style1,{{WRAPPER}} .service-style4',
			]
		);

        $this->add_control(
			'service_title_color',
			[
				'label' 	=> __( 'Service Title Color', 'techbiz' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .feature-style2 .feature-title a,{{WRAPPER}} .service-style3 .service-title a,{{WRAPPER}} .service-style1 .service-title a,{{WRAPPER}} .service-style4 .service-title a' => 'color: {{VALUE}}!important',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'service_title_typography',
				'label' 	=> __( 'Service Title Typography', 'techbiz' ),
                'selector' 	=> '{{WRAPPER}} .feature-style2 .feature-title a,{{WRAPPER}} .service-style3 .service-title a,{{WRAPPER}} .service-style1 .service-title a,{{WRAPPER}} .service-style4 .service-title a',
			]
		);

        $this->add_control(
			'service_desc_color',
			[
				'label' 	=> __( 'Service Desc Color', 'techbiz' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .feature-slide2 .feature-style2 .feature-text,{{WRAPPER}} .service-style3 .service-text,{{WRAPPER}} .service-style1 .service-text,{{WRAPPER}} .service-style4 .service-text' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'service_text_typography',
				'label' 	=> __( 'Service Slider Text Typography', 'techbiz' ),
                'selector' 	=> '{{WRAPPER}} .feature-slide2 .feature-style2 .feature-text,{{WRAPPER}} .service-style3 .service-text,{{WRAPPER}} .service-style1 .service-text,{{WRAPPER}} .service-style4 .service-text',
			]
		);

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		$this->add_render_attribute( 'wrapper', 'class', 'row vs-carousel' );
		$this->add_render_attribute( 'wrapper', 'data-slick-arrows', 'false' );
		$this->add_render_attribute( 'wrapper', 'data-slick-autoplay', 'false' );
		$this->add_render_attribute( 'wrapper', 'data-slide-to-show', $settings['slide_to_show']['size'] );

		if( $settings['service_style'] == '4' ){
			$this->add_render_attribute( 'wrapper', 'data-slick-dots', 'true' );
			$this->add_render_attribute( 'wrapper', 'class', 'dot-style2' );
		}else{
			$this->add_render_attribute( 'wrapper', 'data-slick-dots', 'false' );
		}
		
		echo '<div class="service-wrapper">';
			echo '<div class="container">';
				echo '<div '.$this->get_render_attribute_string('wrapper').'>';
					foreach( $settings['slides'] as $singleslide ) {
						if( $settings['service_style'] == '1' ){
							echo '<div class="col-xl-4">';
								echo '<div class="feature-style2">';
									if( ! empty( $singleslide['service_image']['url'] ) ){
										echo '<div class="feature-icon">';
											echo techbiz_img_tag( array(
												'url'	=> esc_url( $singleslide['service_image']['url'] ),
											) );
										echo '</div>';
									}
									if( ! empty( $singleslide['service_title'] ) ){
										echo '<h3 class="feature-title h5">';
											echo '<a class="text-inherit" href="'.esc_url( $singleslide['service_url'] ).'">'.esc_html( $singleslide['service_title'] ).'</a>';
										echo '</h3>';
									}
									if( ! empty( $singleslide['service_description'] ) ){
										echo '<p class="feature-text">'.wp_kses_post( $singleslide['service_description'] ).'</p>';
									}
									if( ! empty( $singleslide['button_text'] ) ){
										echo '<a href="'.esc_url( $singleslide['service_url'] ).'" class="link-btn">'.esc_html( $singleslide['button_text'] ).'<i class="far fa-arrow-right"></i></a>';
									}
								echo '</div>';
							echo '</div>';
						}elseif( $settings['service_style'] == '2' ){
							echo '<div class="col-xl-3">';
			                    echo '<div class="service-style3">';
			                        echo '<div class="service-front">';
										if( ! empty( $singleslide['service_image']['url'] ) ){
				                            echo '<div class="service-img">';
												echo techbiz_img_tag( array(
													'url'	=> esc_url( $singleslide['service_image']['url'] ),
													'class'	=> 'w-100'
												) );
				                            echo '</div>';
										}
			                            echo '<div class="service-content">';
											if( ! empty( $singleslide['service_bg_image']['url'] ) ){
				                                echo '<div class="service-icon">';
													echo techbiz_img_tag( array(
														'url'	=> esc_url( $singleslide['service_bg_image']['url'] ),
													) );
												echo '</div>';
											}
											if( ! empty( $singleslide['service_title'] ) ){
				                                echo '<h3 class="service-title h6"><a href="'.esc_url( $singleslide['service_url'] ).'">'.esc_html( $singleslide['service_title'] ).'</a></h3>';
											}
			                            echo '</div>';
			                        echo '</div>';
			                        echo '<div class="service-back">';
			                            echo '<div class="service-content">';
											if( ! empty( $singleslide['service_bg_image']['url'] ) ){
												echo '<div class="service-icon">';
													echo techbiz_img_tag( array(
														'url'	=> esc_url( $singleslide['service_bg_image']['url'] ),
													) );
												echo '</div>';
											}
											if( ! empty( $singleslide['service_title'] ) ){
				                                echo '<h3 class="service-title h6"><a href="'.esc_url( $singleslide['service_url'] ).'">'.esc_html( $singleslide['service_title'] ).'</a></h3>';
											}
											if( ! empty( $singleslide['service_description'] ) ){
				                                echo '<p class="service-text">'.wp_kses_post( $singleslide['service_description'] ).'</p>';
											}
											if( ! empty( $singleslide['button_text'] ) ){
				                                echo '<a href="'.esc_url( $singleslide['service_url'] ).'" class="link-btn">'.esc_html( $singleslide['button_text'] ).'<i class="far fa-arrow-right"></i></a>';
											}
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
						}elseif( $settings['service_style'] == '3' ){
							echo '<div class="col-md-6 col-lg-4">';
			                    echo '<div class="service-style1 layout3">';
			                        echo '<div class="service-bg" data-bg-src="'.esc_url( $singleslide['service_bg_image']['url'] ).'"></div>';
			                        echo '<div class="service-top">';
										if( ! empty( $singleslide['service_image']['url'] ) ){
											echo '<div class="service-icon">';
												echo techbiz_img_tag( array(
													'url'	=> esc_url( $singleslide['service_image']['url'] ),
												) );
											echo '</div>';
										}
										if( ! empty( $singleslide['service_numbering'] ) ){
				                            echo '<span class="service-number">'.esc_html( $singleslide['service_numbering'] ).'</span>';
										}
			                        echo '</div>';
									if( ! empty( $singleslide['service_title'] ) ){
				                        echo '<h3 class="service-title h5"><a href="'.esc_url( $singleslide['service_url'] ).'">'.esc_html( $singleslide['service_title'] ).'</a></h3>';
									}
									if( ! empty( $singleslide['service_description'] ) ){
										echo '<p class="service-text">'.wp_kses_post( $singleslide['service_description'] ).'</p>';
									}
									if( ! empty( $singleslide['button_text'] ) ){
										echo '<a href="'.esc_url( $singleslide['service_url'] ).'" class="link-btn">'.esc_html( $singleslide['button_text'] ).'<i class="far fa-arrow-right"></i></a>';
									}
			                    echo '</div>';
			                echo '</div>';
						}elseif( $settings['service_style'] == '4' ){
							echo '<div class="col-xl-4">';
			                    echo '<div class="service-style4">';
			                        echo '<div class="service-top">';
										if( ! empty( $singleslide['service_title'] ) ){
											echo '<h3 class="service-title h5"><a href="'.esc_url( $singleslide['service_url'] ).'">'.esc_html( $singleslide['service_title'] ).'</a></h3>';
										}
										if( ! empty( $singleslide['service_url'] ) ){
				                            echo '<a href="'.esc_url( $singleslide['service_url'] ).'" class="service-btn"><i class="far fa-arrow-right"></i></a>';
										}
			                        echo '</div>';
									if( ! empty( $singleslide['service_description'] ) ){
										echo '<p class="service-text">'.wp_kses_post( $singleslide['service_description'] ).'</p>';
									}
									if( ! empty( $singleslide['service_image']['url'] ) ){
				                        echo '<div class="service-img">';
											echo techbiz_img_tag( array(
												'url'	=> esc_url( $singleslide['service_image']['url'] ),
											) );
				                        echo '</div>';
									}
			                    echo '</div>';
			                echo '</div>';
						}else{
							echo '<div class="col-xl-4">';
			                    echo '<div class="service-style5">';
									if( ! empty( $singleslide['service_image']['url'] ) ){
										echo '<div class="service-img">';
											echo techbiz_img_tag( array(
												'url'	=> esc_url( $singleslide['service_image']['url'] ),
											) );
										echo '</div>';
									}
			                        echo '<div class="service-content">';
										if( ! empty( $singleslide['service_title'] ) ){
											echo '<h3 class="service-title h3"><a class="text-inherit" href="'.esc_url( $singleslide['service_url'] ).'">'.esc_html( $singleslide['service_title'] ).'</a></h3>';
										}
										if( ! empty( $singleslide['service_description'] ) ){
											echo '<p class="service-text">'.wp_kses_post( $singleslide['service_description'] ).'</p>';
										}
										if( ! empty( $singleslide['service_url'] ) ){
				                            echo '<a href="'.esc_url( $singleslide['service_url'] ).'" class="icon-btn style3"><i class="far fa-angle-right"></i></a>';
										}
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
						}
					}
				echo '</div>';
			echo '</div>';
		echo '</div>';
	}
}