<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Repeater;
/**
 *
 * Project Filter Widget .
 *
 */
class Techbiz_Project_Filter extends Widget_Base {

	public function get_name() {
		return 'techbizprojectfilter';
	}

	public function get_title() {
		return __( 'Project Filter', 'techbiz' );
	}


	public function get_icon() {
		return 'eicon-code';
    }


	public function get_categories() {
		return [ 'techbiz' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'project_section',
			[
				'label' 	=> __( 'Project Filter', 'techbiz' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$repeater = new Repeater();

		$repeater->add_control(
			'project_image',
			[
				'label' 	=> esc_html__( 'Project Image', 'techbiz' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' 	=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'project_title',
			[
				'label' 	=> __( 'Project Title', 'techbiz' ),
				'type' 		=> Controls_Manager::TEXTAREA,
				'default'   => __( 'Development Projects', 'techbiz' ),
			]
		);

		$repeater->add_control(
			'project_subtitle',
			[
				'label' 	=> __( 'Project Subtitle', 'techbiz' ),
				'type' 		=> Controls_Manager::TEXTAREA,
				'default'   => __( 'App Solution', 'techbiz' ),
			]
		);

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'techbiz' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'project_title' 		=> __( 'App Development', 'techbiz' ),
						'project_subtitle' 	    => __( 'App Solution', 'techbiz' ),
					],
					[
						'project_title' 		=> __( 'Portfolio Design', 'techbiz' ),
						'project_subtitle' 	    => __( 'UI Design', 'techbiz' ),
					],
					[
						'project_title' 		=> __( 'Database checkup', 'techbiz' ),
						'project_subtitle' 	    => __( 'Cyber Security', 'techbiz' ),
					],
					[
						'project_title' 		=> __( 'Digital Marketing', 'techbiz' ),
						'project_subtitle' 	    => __( 'Affiliate', 'techbiz' ),
					],
				],
				'title_field' 	=> '{{{ project_title }}}',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'project_style_section',
			[
				'label' => __( 'Project Style', 'techbiz' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' 		=> 'background',
				'label' 	=> __( 'Background', 'techbiz' ),
				'types' 	=> [ 'classic', 'gradient', 'video' ],
				'selector' 	=> '{{WRAPPER}} .project-style2 .project-shape',
			]
		);

        $this->add_control(
			'project_title_color',
			[
				'label' 	=> __( 'Project Title Color', 'techbiz' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .project-style2 .project-title' => 'color: {{VALUE}}!important',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'project_title_typography',
				'label' 	=> __( 'Project Title Typography', 'techbiz' ),
                'selector' 	=> '{{WRAPPER}} .project-style2 .project-title',
			]
		);

        $this->add_control(
			'project_subtitle_color',
			[
				'label' 	=> __( 'Project Subtitle Color', 'techbiz' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .project-style2 .project-label' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'project_subtitle_typography',
				'label' 	=> __( 'Project Subtitle Typography', 'techbiz' ),
                'selector' 	=> '{{WRAPPER}} .project-style2 .project-label',
			]
		);

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		echo '<div class="project-wrapper">';
			echo '<div class="container">';
				echo '<div class="row filter-active">';
					foreach( $settings['slides'] as $singleslide ) {
                        echo '<div class="col-md-6 col-xxl-auto filter-item">';
                            echo '<div class="project-style2">';
                                echo '<div class="project-img">';
                                    echo '<div class="project-shape"></div>';
                                    if( ! empty( $singleslide['project_image']['url'] ) ){
                                        echo techbiz_img_tag( array(
                                            'url'	=> esc_url( $singleslide['project_image']['url'] ),
                                        ) );
                                        echo '<a href="'.esc_url( $singleslide['project_image']['url'] ).'" class="icon-btn style4"><i class="far fa-search"></i></a>';
                                    }
                                echo '</div>';
                                echo '<div class="project-content">';
                                    if( ! empty( $singleslide['project_subtitle'] ) ){
                                        echo '<span class="project-label">'.esc_html( $singleslide['project_subtitle'] ).'</span>';
                                    }
                                    if( ! empty( $singleslide['project_title'] ) ){
                                        echo '<h3 class="project-title h5">'.esc_html( $singleslide['project_title'] ).'</h3>';
                                    }
                                echo '</div>';
                            echo '</div>';
                        echo '</div>';
					}
	 			echo '</div>';
 			echo '</div>';
		echo '</div>';
	}
}